/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.ISTORE;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.LocalVariableGen;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.xalan.internal.xsltc.compiler.CastExpr;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Expression;
import com.sun.org.apache.xalan.internal.xsltc.compiler.KeyCall;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Predicate;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.NodeSetType;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ReferenceType;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Util;
import java.util.List;

class FilterExpr
extends Expression {
    private Expression _primary;
    private final List<Expression> _predicates;

    public FilterExpr(Expression expression, List<Expression> list) {
        this._primary = expression;
        this._predicates = list;
        expression.setParent(this);
    }

    protected Expression getExpr() {
        if (this._primary instanceof CastExpr) {
            return ((CastExpr)this._primary).getExpr();
        }
        return this._primary;
    }

    @Override
    public void setParser(Parser parser) {
        super.setParser(parser);
        this._primary.setParser(parser);
        if (this._predicates != null) {
            int n = this._predicates.size();
            for (int i = 0; i < n; ++i) {
                Expression expression = this._predicates.get(i);
                expression.setParser(parser);
                expression.setParent(this);
            }
        }
    }

    @Override
    public String toString() {
        return "filter-expr(" + this._primary + ", " + this._predicates + ")";
    }

    @Override
    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        Type type = this._primary.typeCheck(symbolTable);
        boolean bl = this._primary instanceof KeyCall;
        if (!(type instanceof NodeSetType)) {
            if (type instanceof ReferenceType) {
                this._primary = new CastExpr(this._primary, Type.NodeSet);
            } else {
                throw new TypeCheckError(this);
            }
        }
        int n = this._predicates.size();
        for (int i = 0; i < n; ++i) {
            Predicate predicate = (Predicate)this._predicates.get(i);
            if (!bl) {
                predicate.dontOptimize();
            }
            predicate.typeCheck(symbolTable);
        }
        this._type = Type.NodeSet;
        return this._type;
    }

    @Override
    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this.translateFilterExpr(classGenerator, methodGenerator, this._predicates == null ? -1 : this._predicates.size() - 1);
    }

    private void translateFilterExpr(ClassGenerator classGenerator, MethodGenerator methodGenerator, int n) {
        if (n >= 0) {
            this.translatePredicates(classGenerator, methodGenerator, n);
        } else {
            this._primary.translate(classGenerator, methodGenerator);
        }
    }

    public void translatePredicates(ClassGenerator classGenerator, MethodGenerator methodGenerator, int n) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (n < 0) {
            this.translateFilterExpr(classGenerator, methodGenerator, n);
        } else {
            Predicate predicate = (Predicate)this._predicates.get(n--);
            this.translatePredicates(classGenerator, methodGenerator, n);
            if (predicate.isNthPositionFilter()) {
                int n2 = constantPoolGen.addMethodref("com.sun.org.apache.xalan.internal.xsltc.dom.NthIterator", "<init>", "(Lcom/sun/org/apache/xml/internal/dtm/DTMAxisIterator;I)V");
                LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("filter_expr_tmp1", Util.getJCRefType("Lcom/sun/org/apache/xml/internal/dtm/DTMAxisIterator;"), null, null);
                localVariableGen.setStart(instructionList.append(new ASTORE(localVariableGen.getIndex())));
                predicate.translate(classGenerator, methodGenerator);
                LocalVariableGen localVariableGen2 = methodGenerator.addLocalVariable("filter_expr_tmp2", Util.getJCRefType("I"), null, null);
                localVariableGen2.setStart(instructionList.append(new ISTORE(localVariableGen2.getIndex())));
                instructionList.append(new NEW(constantPoolGen.addClass("com.sun.org.apache.xalan.internal.xsltc.dom.NthIterator")));
                instructionList.append(DUP);
                localVariableGen.setEnd(instructionList.append(new ALOAD(localVariableGen.getIndex())));
                localVariableGen2.setEnd(instructionList.append(new ILOAD(localVariableGen2.getIndex())));
                instructionList.append(new INVOKESPECIAL(n2));
            } else {
                int n3 = constantPoolGen.addMethodref("com.sun.org.apache.xalan.internal.xsltc.dom.CurrentNodeListIterator", "<init>", "(Lcom/sun/org/apache/xml/internal/dtm/DTMAxisIterator;ZLcom/sun/org/apache/xalan/internal/xsltc/dom/CurrentNodeListFilter;ILcom/sun/org/apache/xalan/internal/xsltc/runtime/AbstractTranslet;)V");
                LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("filter_expr_tmp1", Util.getJCRefType("Lcom/sun/org/apache/xml/internal/dtm/DTMAxisIterator;"), null, null);
                localVariableGen.setStart(instructionList.append(new ASTORE(localVariableGen.getIndex())));
                predicate.translate(classGenerator, methodGenerator);
                LocalVariableGen localVariableGen3 = methodGenerator.addLocalVariable("filter_expr_tmp2", Util.getJCRefType("Lcom/sun/org/apache/xalan/internal/xsltc/dom/CurrentNodeListFilter;"), null, null);
                localVariableGen3.setStart(instructionList.append(new ASTORE(localVariableGen3.getIndex())));
                instructionList.append(new NEW(constantPoolGen.addClass("com.sun.org.apache.xalan.internal.xsltc.dom.CurrentNodeListIterator")));
                instructionList.append(DUP);
                localVariableGen.setEnd(instructionList.append(new ALOAD(localVariableGen.getIndex())));
                instructionList.append(ICONST_1);
                localVariableGen3.setEnd(instructionList.append(new ALOAD(localVariableGen3.getIndex())));
                instructionList.append(methodGenerator.loadCurrentNode());
                instructionList.append(classGenerator.loadTranslet());
                instructionList.append(new INVOKESPECIAL(n3));
            }
        }
    }
}

